/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class GetDirSizeCommand
extends VerificationCommand {
    private static String m_arg1 = "-getdirsize";
    private String m_path;

    public GetDirSizeCommand(String nodeName, String path) {
        super(nodeName, null, null);
        this.m_path = path;
        String[] args = new String[]{m_arg1, this.m_path};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("GetDirSizeCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for GetDirSizeCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting exectask version failed");
            result.addErrorInfo("getting exectask version failed");
            result.setStatus(2);
            return false;
        }
        Trace.out((String)"super.execute() was succcessful for GetDirSizeCommand...");
        String[] resultString = this.getCommandResult().getResultString();
        String fmtdStr = VerificationUtil.strArr2List(resultString, "\n");
        if (!VerificationUtil.fetchExecResult(fmtdStr)) {
            String trcTxt = "Exectask result shows failure for -getdirsize...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting directory size failed");
            result.addErrorInfo("getting directory size failed");
            result.setStatus(2);
            return false;
        }
        if (!VerificationUtil.fetchVerificationResult(fmtdStr).equals("0")) {
            String errString = VerificationUtil.fetchError(fmtdStr);
            if (VerificationUtil.isStringGood(errString)) {
                result.addErrorDescription(new ErrorDescription(errString));
            }
            String trcTxt = "Exectask result shows failure for -getdirsize...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"getting directory size failed");
            result.addErrorInfo("getting directory size failed");
            result.setStatus(3);
            return true;
        }
        String dirSize = VerificationUtil.fetchVerificationValue(fmtdStr);
        Trace.out((String)"after calling fetchVerificationValue() ");
        Trace.out((String)("The size of path " + this.m_path + " at node '" + this.getNodeName() + "' is '" + dirSize + "'"));
        result.addTraceInfo("The size of path " + this.m_path + " at node '" + this.getNodeName() + "' is '" + dirSize + "'");
        result.addResultInfo(dirSize);
        result.setStatus(1);
        result.setActualValue(dirSize);
        result.setHasResultValues(true);
        return true;
    }
}

